function [F_hat,lambda_hat,r_hat]=QFM(X,kmax,tol,tau)

%%%% input
% X: T by N matrix of observed variables.
% 0<tau<1: the quantile level
% tol: the convergence threshold of the IQR algorithm
% kmax: the maximum number of factors

%%%% output
% F_hat: a T by r matrix of estimated quantile factors
% lambda_hat: a N by r matrix of estimated quantile factor loadings
% r_hat: the estimated number of quantile factors

[T,N]=size(X);
 L=min(N,T);
pan=(1/L)^(1/3);


[Fhat,Lhat]=IQR(X,kmax,tol,tau);
dum=Lhat'*Lhat/N;
rhat=sum( diag(dum)>pan*dum(1,1));



[Fhat,Lhat]=IQR(X,rhat,tol,tau);


F_hat=Fhat;
lambda_hat=Lhat;
r_hat=rhat;





